//ON APP START
$(document).ready(function () {
    translate();
    startLoading(getCarriersForRegistrationForm);
    resetRegistrationForm();
    resetLoginForm();
    resetFormsValids();
    document.getElementById('loggedUserName').innerHTML = ((isUserLogged()) ? getUserName() : '');
});

// ON LOGIN
$("#loginForm").on('submit', function (e) {
    e.preventDefault();

    var fields = [
        { querySelector: "#loginForm input[name=email]", regExp: /(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|"(?:[\x01-\x08\x0b\x0c\x0e-\x1f\x21\x23-\x5b\x5d-\x7f]|\\[\x01-\x09\x0b\x0c\x0e-\x7f])*")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\x01-\x08\x0b\x0c\x0e-\x1f\x21-\x5a\x53-\x7f]|\\[\x01-\x09\x0b\x0c\x0e-\x7f])+)\])/ },
        { querySelector: "#loginForm input[name=password]", regExp: /(.|\s)*\S(.|\s)*/ },
    ];

    fields.forEach(function (field) {
        validateField(field.querySelector, field.regExp);
    });

    if ($('.is-invalid').length > 0) {
        addToast('Vision Cargo Mobile', lang.login_form_error, 'danger');
        return;
    }

    var email = $("#loginForm input[name=email]").val();
    var password = $("#loginForm input[name=password]").val();

    startLoading(function () { getApiToken(email, password); });
});

$("#logoutButton").on('click', function () {
    startLoading(function () {
        unsetApiToken();

        if (!isUserLogged()) {
            document.getElementById('loggedUserName').innerHTML = '';
            endLoading(['#content', '#loginFormWrapper', '#informationsWrapper'], addToast('Vision Cargo Mobile', lang.logged_out_successful, 'success'));
        } else {
            endLoading(['#content', '#userProfileWrapper', '#informationsWrapper', '#routesFilterWrapper', '#logoutButton'], addToast('Vision Cargo Mobile', lang.logged_out_error, 'danger'));
        }
    });
});

//ON REGISTRATION
var carriers;
var htmlDriver;
var htmlCarrier;

$("#registerNowButton").on('click', function () {
    startLoading(function () {
        var toShow = (isUserLogged()) ? ['#content', '#userProfileWrapper', '#informationsWrapper', '#logoutButton'] : ['#content', '#registrationFormWrapper', '#informationsWrapper'];
        endLoading(toShow);
    });
});

//ON PASSWORD RESET
$("#resetPasswordButton").on('click', function () {
    startLoading(function () {
        var toShow = (isUserLogged()) ? ['#content', '#userProfileWrapper', '#informationsWrapper', '#logoutButton'] : ['#content', '#resetPasswordFormWrapper', '#informationsWrapper'];
        endLoading(toShow);
    });
});

//ON BACK TO LOGIN FORM
$(".backToLoginForm").on('click', function () {
    startLoading(function () {
        resetRegistrationForm();
        resetFormsValids();
        getAdditionalFieldsForRegistrationForm();
        var toShow = (isUserLogged()) ? ['#content', '#userProfileWrapper', '#informationsWrapper', '#logoutButton'] : ['#content', '#loginFormWrapper', '#informationsWrapper'];
        endLoading(toShow);
    });
});


// ///////////////////////////////////////////////////////////////////////////

$("#registrationForm").on('submit', function (e) {
    e.preventDefault();

    var basicFields = [
        { querySelector: "#registrationForm input[name=name]", regExp: /^[A-Za-zżźćńółęąśŻŹĆĄŚĘŁÓŃ]+$/ },
        { querySelector: "#registrationForm input[name=surname]", regExp: /^[A-Za-zżźćńółęąśŻŹĆĄŚĘŁÓŃ]+$/ },
        { querySelector: "#registrationForm input[name=phone]", regExp: /^(?=.*[0-9])[- +()0-9]+$/ },
        { querySelector: "#registrationForm input[name=email]", regExp: /(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|"(?:[\x01-\x08\x0b\x0c\x0e-\x1f\x21\x23-\x5b\x5d-\x7f]|\\[\x01-\x09\x0b\x0c\x0e-\x7f])*")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\x01-\x08\x0b\x0c\x0e-\x1f\x21-\x5a\x53-\x7f]|\\[\x01-\x09\x0b\x0c\x0e-\x7f])+)\])/ },
        { querySelector: "#registrationForm input[name=password]", regExp: /(.|\s)*\S(.|\s)*/ },
        { querySelector: "#registrationForm input[name=password_confirmation]", regExp: /(.|\s)*\S(.|\s)*/ },
        { querySelector: "#registrationForm select[name=roles]", regExp: /^[1-9]$/ },
    ];
    var additionalFields;

    basicFields.forEach(function (field) {
        validateField(field.querySelector, field.regExp);
    });

    if ($("#registrationForm select[name=roles]").val() == 1) {
        additionalFields = [
            { querySelector: "#registrationForm input[name=doc_number]", regExp: /(.|\s)*\S(.|\s)*/ },
            { querySelector: "#registrationForm select[name=carrier_id]", regExp: /(.|\s)*\S(.|\s)*/ },
        ];
    }
    if ($("#registrationForm select[name=roles]").val() == 2) {
        additionalFields = [
            { querySelector: "#registrationForm input[name=company]", regExp: /(.|\s)*\S(.|\s)*/ },
            { querySelector: "#registrationForm input[name=ein]", regExp: /(.|\s)*\S(.|\s)*/ },
            { querySelector: "#registrationForm input[name=dot]", regExp: /(.|\s)*\S(.|\s)*/ },
            { querySelector: "#registrationForm input[name=mc]", regExp: /(.|\s)*\S(.|\s)*/ },
        ];
    }

    if (typeof additionalFields !== 'undefined' && additionalFields.length > 0) {
        additionalFields.forEach(function (field) {
            validateField(field.querySelector, field.regExp);
        });
    }

    if ($('.is-invalid').length > 0) {
        addToast('Vision Cargo Mobile', lang.registration_data_error, 'danger');
        return;
    }

    var registrationData = {
        name: $("#registrationForm input[name=name]").val(),
        surname: $("#registrationForm input[name=surname]").val(),
        phone: $("#registrationForm input[name=phone]").val(),
        email: $("#registrationForm input[name=email]").val(),
        password: $("#registrationForm input[name=password]").val(),
        password_confirmation: $("#registrationForm input[name=password_confirmation]").val(),
        roles: $("#registrationForm select[name=roles]").val(),
    };

    if ($("#registrationForm select[name=roles]").val() == 1) {
        registrationData.doc_number = $("#registrationForm input[name=doc_number]").val();
        registrationData.carrier_id = $("#registrationForm select[name=carrier_id]").val();
    }
    if ($("#registrationForm select[name=roles]").val() == 2) {
        registrationData.company = $("#registrationForm input[name=company]").val();
        registrationData.nip = $("#registrationForm input[name=nip]").val();
        registrationData.regon = $("#registrationForm input[name=regon]").val();
        registrationData.krs = $("#registrationForm input[name=krs]").val();
    }

    if (registrationData.password === registrationData.password_confirmation) {
        startLoading(registerUser(registrationData));
    }
    else {
        addToast('Vision Cargo Mobile', lang.password_confirmation_error, 'danger')
    }
});

$("#resetPasswordForm").on('submit', function (e) {
    e.preventDefault();

    var basicFields = [
        { querySelector: "#resetPasswordForm input[name=email]", regExp: /(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|"(?:[\x01-\x08\x0b\x0c\x0e-\x1f\x21\x23-\x5b\x5d-\x7f]|\\[\x01-\x09\x0b\x0c\x0e-\x7f])*")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\x01-\x08\x0b\x0c\x0e-\x1f\x21-\x5a\x53-\x7f]|\\[\x01-\x09\x0b\x0c\x0e-\x7f])+)\])/ },
    ];

    basicFields.forEach(function (field) {
        validateField(field.querySelector, field.regExp);
    });

    if ($('.is-invalid').length > 0) {
        addToast('Vision Cargo Mobile', lang.registration_data_error, 'danger');
        return;
    }

    var resetPasswordData = {
        email: $("#resetPasswordForm input[name=email]").val(),
    };

    startLoading(resetPassword(resetPasswordData));
});

$('#roles').change(function () {
    getAdditionalFieldsForRegistrationForm();
});

//ROUTES
$('#backToHomeButton').on('click', function () {
    startLoading(function () {
        var toShow = (isUserLogged()) ? ['#content', '#userProfileWrapper', '#routesFilterWrapper', '#logoutButton'] : ['#content', '#loginFormWrapper', '#informationsWrapper'];
        endLoading(toShow);
    });
});

$('#backToRoutesListButton').on('click', function () {
    startLoading(function () {
        var toShow = (isUserLogged()) ? ['#content', '#userProfileWrapper', '#routesListWrapper', '#backToHomeButton', '#logoutButton'] : ['#content', '#loginFormWrapper', '#informationsWrapper'];
        endLoading(toShow);
    });
});

$("#availableRoutesButton").on('click', function () {
    startLoading(function () {
        getRoutes('available');
    });
});

$("#acceptedRoutesButton").on('click', function () {
    startLoading(function () {
        getRoutes('accepted');
    });
});

$("#archiveRoutesButton").on('click', function () {
    startLoading(function () {
        getRoutes('archive');
    });
});