// HELPERS
function startLoading(callback = function () { return 0; }) {
    var callback = callback;

    $("#loadingSpinner, #loadingError, #content, #loginFormWrapper, #registrationFormWrapper, #resetPasswordFormWrapper, #logoutButton, #routesFilterWrapper, #routesListWrapper, #informationsWrapper, #userProfileWrapper, #backToHomeButton, #backToRoutesListButton, #routeDetailsWrapper").fadeOut(500).promise().done(function (event) {
        $("#loadingSpinner").fadeIn(500, function () {
            callback();
        });
    });
}

function endLoading(toShow = [], callback = function () { return 0; }) {
    var callback = callback;

    $("#loadingSpinner").fadeOut(500).promise().done(function () {
        if (!(toShow === undefined || toShow.length == 0)) {
            $(toShow.join(', ')).fadeIn(500, function () {
                callback();
            });
        }
    });
}

function changeLanguage(locale) {
    localStorage.setItem('locale', locale);
    lang = getCurrentLang();
    translate();
}

function translate() {
    if (lang !== undefined || lang !== null) {
        var textElements = document.getElementsByClassName('mtr__translateText');
        var placeholderElements = document.getElementsByClassName('mtr__translatePlaceholder');
        var valueElements = document.getElementsByClassName('mtr__translateValue');
        var titleElements = document.getElementsByClassName('mtr__translateTitle');

        for (var i = 0; i < textElements.length; i++) {
            let key = textElements.item(i).getAttribute('translate_string');
            textElements.item(i).innerHTML = lang[key];
        }

        for (var i = 0; i < placeholderElements.length; i++) {
            let key = placeholderElements.item(i).getAttribute('translate_string');
            placeholderElements.item(i).placeholder = lang[key] + '...';
        }

        for (var i = 0; i < valueElements.length; i++) {
            let key = valueElements.item(i).getAttribute('translate_string');
            valueElements.item(i).value = lang[key];
        }

        for (var i = 0; i < titleElements.length; i++) {
            let key = titleElements.item(i).getAttribute('translate_string');
            titleElements.item(i).title = lang[key];
        }
    }
}

function validateField(querySelector, regExp) {
    var regExp = new RegExp(regExp);
    var el = $(querySelector);
    var value = el.val();

    if (el.hasClass('is-invalid')) el.removeClass('is-invalid');
    if (el.hasClass('is-valid')) el.removeClass('is-valid');

    if (!value.match(regExp)) {
        el.addClass('is-invalid');
        return true;
    } else {
        el.addClass('is-valid');
        return false;
    }
}

function addToast(header = "Header", message = "Message", color = "primary") {
    var id = (Math.random() + 1).toString(36).substring(2);

    document.getElementById("toast-container").innerHTML += `
    <div id="${id}" class="toast mx-auto align-items-center border-0" role="alert" aria-live="assertive" aria-atomic="true" data-bs-autohide="true" data-bs-delay="4000">
        <div class="toast-header text-white bg-dark">
            <strong class="me-auto">${header}</strong>
        </div>
        <div class="toast-body text-white bg-${color}">
            ${message}
        </div>
    </div>
    `;

    var bsToast = new bootstrap.Toast(document.getElementById(id));
    bsToast.show();
    setTimeout(function () { $('.toast').remove(); }, 7000);
}



// LOGIN
function getApiToken(email, password) {
    $.ajax({
        type: 'POST',
        url: appURL + `api/getAuthToken`,
        crossDomain: true,
        data: {
            "email": email.toString(),
            "password": password.toString(),
            "locale": localStorage.getItem('locale')
        },
        dataType: 'json',
        success: function (responseData) {
            var api_token = responseData.api_token;
            var user_name = responseData.user_name;
            var user_role = responseData.user_role;
            var user_carrier = responseData.carrier;
            var user_drivers = responseData.drivers;
            var user_trucks = responseData.trucks;
            var user_semitrailers = responseData.semitrailers;

            var message = responseData.message;

            setApiToken(api_token, user_name, user_role, user_carrier, user_drivers, user_trucks, user_semitrailers);

            document.getElementById('loggedUserName').innerHTML = ((isUserLogged()) ? getUserName() : '');
            resetLoginForm();
            resetFormsValids();

            var toShow = (isUserLogged()) ? ['#content', '#userProfileWrapper', '#informationsWrapper', '#routesFilterWrapper', '#logoutButton'] : ['#content', '#loginFormWrapper', '#informationsWrapper'];
            endLoading(toShow, addToast('Vision Cargo Mobile', message, 'success'));
        },
        error: function (responseData) {
            var message = JSON.parse(responseData.responseText).message

            resetFormsValids();

            var toShow = (isUserLogged()) ? ['#content', '#userProfileWrapper', '#informationsWrapper', '#routesFilterWrapper', '#logoutButton'] : ['#content', '#loginFormWrapper', '#informationsWrapper'];
            endLoading(toShow, addToast('Vision Cargo Mobile', message, 'danger'));
        }
    });
}

function setApiToken(api_token, user_name, user_role, user_carrier, user_drivers, user_trucks, user_semitrailers) {
    localStorage.setItem('api_token', api_token);
    localStorage.setItem('user_name', user_name);
    localStorage.setItem('user_role', user_role);
    localStorage.setItem('user_carrier', JSON.stringify(user_carrier));
    localStorage.setItem('user_drivers', JSON.stringify(user_drivers));
    localStorage.setItem('user_trucks', JSON.stringify(user_trucks));
    localStorage.setItem('user_semitrailers', JSON.stringify(user_semitrailers));
}

function unsetApiToken() {
    localStorage.removeItem('api_token');
    localStorage.removeItem('user_name');
    localStorage.removeItem('user_role');
    localStorage.removeItem('user_carrier');
    localStorage.removeItem('user_drivers');
    localStorage.removeItem('user_trucks');
    localStorage.removeItem('user_semitrailers');
}

function isUserLogged() {
    return (localStorage.getItem('api_token') && localStorage.getItem('user_name') && localStorage.getItem('user_role')) ? true : false;
}

function getUserName() {
    return (localStorage.getItem('user_name')) ? localStorage.getItem('user_name') : null;
}

function getUserRole() {
    return (localStorage.getItem('user_role')) ? localStorage.getItem('user_role') : null;
}

function getUserCarrier() {
    return (localStorage.getItem('user_carrier')) ? JSON.parse(localStorage.getItem('user_carrier')) : null;
}

function getUserDrivers() {
    return (localStorage.getItem('user_drivers')) ? JSON.parse(localStorage.getItem('user_drivers')) : null;
}

function getUserTrucks() {
    return (localStorage.getItem('user_trucks')) ? JSON.parse(localStorage.getItem('user_trucks')) : null;
}

function getUserSemitrailers() {
    return (localStorage.getItem('user_semitrailers')) ? JSON.parse(localStorage.getItem('user_semitrailers')) : null;
}

// REGISTER
function getCarriersForRegistrationForm() {
    $.ajax({
        type: 'GET',
        url: appURL + `api/getCarriers`,
        crossDomain: true,
        dataType: 'json',
        timeout: 10000,
        success: function (responseData) {
            generateAdditionalFieldsForRegistrationForm(responseData);
            var toShow = (isUserLogged()) ? ['#content', '#userProfileWrapper', '#informationsWrapper', '#routesFilterWrapper', '#logoutButton'] : ['#content', '#loginFormWrapper', '#informationsWrapper'];
            endLoading(toShow);
        },
        error: function (textStatus) {
            var message;
            if (textStatus == 'timeout') {
                message = lang.timeout_error;
            } else {
                message = lang.get_carriers_error;
            }

            var toShow = (isUserLogged()) ? ['#content', '#userProfileWrapper', '#informationsWrapper', '#routesFilterWrapper', '#logoutButton'] : ['#content', '#loginFormWrapper', '#informationsWrapper'];
            endLoading(toShow, addToast('Vision Cargo Mobile', message, 'danger'));
        }
    });
}

function generateAdditionalFieldsForRegistrationForm(carriers) {
    htmlDriver =
        `<input class='form-control mb-1 mtr__translatePlaceholder' type='text' id='doc_number' name='doc_number' translate_string='doc_number' placeholder='${lang.doc_number}...'>`;
    htmlDriver +=
        "<select class='form-select mb-1' name='carrier_id'>";
    carriers.forEach(function (carrier, index) {
        htmlDriver += '<option value="' + carrier.id + '">' + carrier.company + '</option>';
    });
    htmlDriver += "</select>";

    htmlCarrier =
        `
                <input id='company' type='text' class='form-control mb-1 mtr__translatePlaceholder' name='company' translate_string="company" required autocomplete='off' placeholder="${lang.company}...">   
                <input id='ein' type='text' class='form-control mb-1 mtr__translatePlaceholder' translate_string="ein" name='ein' required autocomplete='off' placeholder="${lang.ein}...">
                <input id='dot' type='text' class='form-control mb-1 mtr__translatePlaceholder' translate_string="dot" name='dot' autocomplete='off' placeholder="${lang.dot}...">
                <input id='mc' type='text' class='form-control mb-1 mtr__translatePlaceholder' translate_string="mc" name='mc' autocomplete='off' placeholder="${lang.mc}...">
        `;

    $('#additionalFields').html(htmlDriver);
    translate();
}

function getAdditionalFieldsForRegistrationForm() {
    let id = $('#roles').val();

    if (id == 1) {
        $('#additionalFields').html(htmlDriver);
    } else if (id == 2) {
        $('#additionalFields').html(htmlCarrier);
    } else {
        $('#additionalFields').html('');
    }
}

function registerUser(registrationData) {
    var data = Object.assign(registrationData, { "locale": localStorage.getItem('locale') });

    $.ajax({
        type: 'POST',
        url: appURL + `api/register`,
        crossDomain: true,
        data: data,
        dataType: 'json',
        success: function (responseData, textStatus, jqXHR) {
            if (responseData.status == "error") {
                var responseMessage = "";
                for (var message in responseData.message) {
                    if (responseData.message.hasOwnProperty(message)) {
                        responseMessage += responseData.message[message] + '<br>';
                    }
                }
                var toShow = (isUserLogged()) ? ['#content', '#userProfileWrapper', '#informationsWrapper', '#logoutButton'] : ['#content', '#registrationFormWrapper'];
                endLoading(toShow, addToast('Vision Cargo Mobile', responseMessage, 'danger'));
            } else {
                var toShow = (isUserLogged()) ? ['#content', '#userProfileWrapper', '#informationsWrapper', '#logoutButton'] : ['#content', '#loginFormWrapper', '#informationsWrapper'];
                resetRegistrationForm();
                resetFormsValids();
                endLoading(toShow, addToast('Vision Cargo Mobile', responseData.message, 'success'));
            }
        },
        error: function (responseData, textStatus, errorThrown) {
            var message = JSON.parse(responseData.responseText).message;
            var toShow = (isUserLogged()) ? ['#content', '#userProfileWrapper', '#informationsWrapper', '#logoutButton'] : ['#content', '#registrationFormWrapper'];
            endLoading(toShow, addToast('Vision Cargo Mobile', message, 'danger'));
        }
    });
}

function resetPassword(resetPasswordData) {
    var data = Object.assign(resetPasswordData, { "locale": localStorage.getItem('locale') });

    $.ajax({
        type: 'POST',
        url: appURL + `api/resetPassword`,
        crossDomain: true,
        data: data,
        dataType: 'json',
        success: function (responseData, textStatus, jqXHR) {
            if (responseData.status == "error") {
                var responseMessage = "";
                for (var message in responseData.message) {
                    if (responseData.message.hasOwnProperty(message)) {
                        responseMessage += responseData.message[message] + '<br>';
                    }
                }
                var toShow = (isUserLogged()) ? ['#content', '#userProfileWrapper', '#informationsWrapper', '#logoutButton'] : ['#content', '#resetPasswordFormWrapper', '#informationsWrapper'];
                endLoading(toShow, addToast('Vision Cargo Mobile', responseMessage, 'danger'));
            } else {
                var toShow = (isUserLogged()) ? ['#content', '#userProfileWrapper', '#informationsWrapper', '#logoutButton'] : ['#content', '#loginFormWrapper', '#informationsWrapper'];
                resetResetPasswordForm();
                resetFormsValids();
                endLoading(toShow, addToast('Vision Cargo Mobile', responseData.message, 'success'));
            }
        },
        error: function (responseData, textStatus, errorThrown) {
            var message = JSON.parse(responseData.responseText).message;
            var toShow = (isUserLogged()) ? ['#content', '#userProfileWrapper', '#informationsWrapper', '#logoutButton'] : ['#content', '#loginFormWrapper', '#informationsWrapper'];
            endLoading(toShow, addToast('Vision Cargo Mobile', message, 'danger'));
        }
    });
}

function resetRegistrationForm() {
    $("#registrationForm input[name=name]").val("");
    $("#registrationForm input[name=surname]").val("");
    $("#registrationForm input[name=phone]").val("");
    $("#registrationForm input[name=email]").val("");
    $("#registrationForm input[name=password]").val("");
    $("#registrationForm input[name=password_confirmation]").val("");
    $("#registrationForm select[name=roles]").val("1");
    $("#registrationForm input[name=doc_number]").val("");
    $("#registrationForm input[name=company]").val("");
    $("#registrationForm input[name=ein]").val("");
    $("#registrationForm input[name=dot]").val("");
    $("#registrationForm input[name=mc]").val("");
}

function resetResetPasswordForm() {
    $("#resetPasswordForm input[name=email]").val("");
}

function resetLoginForm() {
    $("#loginForm input[name=email]").val("");
    $("#loginForm input[name=password]").val("");
}

function resetFormsValids() {
    $(".is-valid").each(function (index) {
        $(this).removeClass('is-valid')
    });

    $(".is-invalid").each(function (index) {
        $(this).removeClass('is-invalid')
    });
}

//ROUTES
function getRoutes(type = 'available', show = true) {
    if (!isUserLogged()) return null;

    var endpoint = (
        (type == 'available') ? 'getAvailableRoutes' : (
            (type == 'accepted') ? 'getAcceptedRoutes' : (
                (type == 'archive') ? 'getArchivedRoutes' : ''
            )));

    $.ajax({
        type: 'POST',
        url: appURL + `api/${endpoint}`,
        crossDomain: true,
        data: {
            "api_token": localStorage.getItem('api_token'),
            "locale": localStorage.getItem('locale')
        },
        dataType: 'json',
        success: function (responseData) {
            generateRoutesHTML(type, responseData.data, show);
        },
        error: function (responseData) {
            var message = JSON.parse(responseData.responseText).message
            var toShow = (isUserLogged()) ? ['#content', '#userProfileWrapper', '#routerFilterWrapper', '#logoutButton'] : ['#content', '#loginFormWrapper', '#informationsWrapper'];
            endLoading(toShow, addToast('Vision Cargo Mobile', message, 'danger'));
        }
    });

    return true;
}

function generateRoutesHTML(type, routes, show) {
    $('#routesListHeader').html(
        ((type == 'available') ? lang.available_routes : ((type == 'accepted') ? lang.accepted_routes : ((type == 'archive') ? lang.archive_routes : '')))
    );

    $('#routesListHeader').attr('translate_string',
        ((type == 'available') ? 'available_routes' : ((type == 'accepted') ? 'accepted_routes' : ((type == 'archive') ? 'archive_routes' : '')))
    );

    if (routes && routes.length > 0) {
        $("#routesListWrapper .list-group").html('');

        routes.forEach(function (route, index) {
            $(`
            <li class="list-group-item list-group-item-action" aria-current="true">
                <div class="row mb-2">
                    <div class="col-7" onclick="getRouteDetails(${route.id})">
                        <h5 class="mb-1">${route.name}</h5>
                        <p class="mb-1"><span class="mtr__translateText" translate_string="info">${lang.info}</span>: ${route.info}</p>
                    </div>
                    <div class="col-5">
                        <a href="tel:${route.shipper.user.phone}" class="w-100 d-flex align-items-center justify-content-center btn btn-primary border rounded text-white mb-2">
                            <i class="fas fa-phone fs-1" aria-hidden="true"></i>
                        </a>
                        <small class="float-end text-end">
                            <span class="mtr__translateText" translate_string="shipper">${lang.shipper}</span>: <br>${route.shipper.user.name} ${route.shipper.user.surname}
                        </small>
                    </div>
                </div>
                <div class="row">
                    <div class="d-flex justify-content-between">
                        <small>
                            <span class="mtr__translateText" translate_string="loads_count">
                                ${lang.loads_count}
                            </span>
                            ${route.loads_count}
                        </small>
                        <small>
                            <span class="mtr__translateText" translate_string="route_id">
                                ${lang.route_id}
                            </span>
                            ${route.id}
                        </small>
                    </div>
                </div>
            </li>
            `).appendTo("#routesListWrapper .list-group");
        });
    } else {
        $("#routesListWrapper .list-group").html(`
            <li class="list-group-item alert alert-warning d-flex align-items-center m-0 py-3" role="alert">
                <i class="me-2 fs-1 fas fa-exclamation-circle"></i>
                <span class="mtr__translateText" translate_string="no_routes">
                    ${lang.no_routes}
                </span>
            </li>
        `);
    }

    if (show) {
        toShow = (isUserLogged()) ? ['#content', '#userProfileWrapper', '#backToHomeButton', '#routesListWrapper', '#logoutButton'] : ['#content', '#loginFormWrapper', '#informationsWrapper'];

        endLoading(toShow);
    }
}

function getRouteDetails(id, show = true) {
    var id = id;

    startLoading(function () {
        if (!isUserLogged()) return null;
        $.ajax({
            type: 'POST',
            url: appURL + `api/route/${id}/details`,
            crossDomain: true,
            data: {
                "api_token": localStorage.getItem('api_token'),
                "locale": localStorage.getItem('locale')
            },
            dataType: 'json',
            success: function (responseData) {
                generateRouteDetailsHTML(responseData, show);
            },
            error: function (responseData) {
                var message = JSON.parse(responseData.responseText).message
                var toShow = (isUserLogged()) ? ['#content', '#userProfileWrapper', '#routerListWrapper', '#backToHomeButton', '#logoutButton'] : ['#content', '#loginFormWrapper', '#informationsWrapper'];
                endLoading(toShow, addToast('Vision Cargo Mobile', message, 'danger'));
            }
        });
        return true;
    });
}

function generateRouteDetailsHTML(routeDetails, show) {

    if (routeDetails) {
        $("#routeDetails .list-group").html('');
        $("#routeDetails .list-group").append(`
            <li class="list-group-item d-flex align-items-center justify-content-between">
                <span class="fw-bold mtr__translateText" translate_string="route_name">
                    ${lang.route_name} (<span class="mtr__translateText" translate_string="id">${lang.id}</span>)
                </span>
                <span>
                    ${routeDetails.name + " (" + routeDetails.id + ")"}
                </span>
            </li>
            <li class="list-group-item d-flex align-items-center justify-content-between">
                <span class="fw-bold mtr__translateText" translate_string="truck_type">
                    ${lang.truck_type}
                </span>
                <span class="w-50 text-end">
                    ${(routeDetails.truck != null) ? routeDetails.truck.trucktype : '-'}
                </span>
            </li>
            <li class="list-group-item d-flex align-items-center justify-content-between">
                <span class="fw-bold mtr__translateText" translate_string="status">
                    ${lang.status}
                </span>
                <span class="w-50 text-end mtr__translateText" translate_string="${(routeDetails.status == 'available') ? "route_available" :
                (routeDetails.status == 'confirmed') ? "route_accepted" :
                    (routeDetails.status == 'refused') ? "route_refused" :
                        (routeDetails.status == 'ended') ? "route_ended" :
                            (routeDetails.status == 'archive') ? "route_archived" : '-'}">
                ${(routeDetails.status == 'available') ? lang.route_available :
                (routeDetails.status == 'confirmed') ? lang.route_accepted :
                    (routeDetails.status == 'refused') ? lang.route_refused :
                        (routeDetails.status == 'ended') ? lang.route_ended :
                            (routeDetails.status == 'archive') ? lang.route_archived : '-'
            }
                </span>
            </li>
            <li class="list-group-item d-flex align-items-center justify-content-between">
                <span class="fw-bold mtr__translateText" translate_string="shipper">
                    ${lang.shipper}
                </span>
                <span class="w-50 text-end">
                ${routeDetails.shipper.user.name + " " + routeDetails.shipper.user.surname + ",<br>" + routeDetails.shipper.user.phone + ",<br>" + routeDetails.shipper.user.email}
                </span>
            </li>
            <li class="list-group-item d-flex align-items-center justify-content-between">
                <span class="fw-bold mtr__translateText" translate_string="carrier">
                    ${lang.carrier}
                </span>
                <span class="w-50 text-end">
                ${((routeDetails.carrier != null) ? (routeDetails.carrier.user.name + " " + routeDetails.carrier.user.surname + ",<br>" + routeDetails.carrier.user.phone + ",<br>" + routeDetails.carrier.user.email) : '-')}
                </span>
            </li>
            <li class="list-group-item d-flex align-items-center justify-content-between">
                <span class="fw-bold mtr__translateText" translate_string="additional_info">
                    ${lang.additional_info}
                </span>
                <span class="w-50 text-end">
                    ${routeDetails.info}
                </span>
            </li>           
        `);

        $("#routeConfirmation .list-group").html('');
        if (routeDetails.status == "available") {
            $("#routeConfirmation").show();
            $("#routeConfirmation .list-group").append(`
                    <form id="routeDetailsChangeStatusForm" class="text-center" action="#" onsubmit="return false;">
                        <li class="list-group-item d-flex align-items-center justify-content-between">
                            <label class="fw-bold mtr__translateText" translate_string="driver" for="driver_id">${lang.driver}</label>
                            <select class="form-select w-50 ms-3 py-2 pe-4" id="routeDetailsChangeStatusFormDriver" name="driver_id">
                                ${(getUserRole() == 'carrier') ? `<option value="0" selected="" class="mtr__translateText" translate_string="self_employment">${lang.self_employment}</option>` : ``}
                            </select>
                        </li>
                        <li class="list-group-item d-flex align-items-center justify-content-between">
                            <label class="fw-bold mtr__translateText" translate_string="truck" for="truck_id">${lang.truck}</label>
                            <select class="form-select w-50 ms-3 py-2 pe-4" id="routeDetailsChangeStatusFormTruck" name="truck_id"></select>
                        </li>
                        <li class="list-group-item d-flex align-items-center justify-content-between">
                            <label for="semitrailer1_id" class="fw-bold mtr__translateText" translate_string="first_semitrailer">${lang.first_semitrailer}</label>
                            <select class="form-select w-50 ms-3 py-2 pe-4" id="routeDetailsChangeStatusFormSemitrailer1" name="semitrailer1_id"></select>
                        </li>
                        <li class="list-group-item d-flex align-items-center justify-content-between">
                            <label for="semitrailer2_id" class="fw-bold mtr__translateText" translate_string="second_semitrailer">${lang.second_semitrailer}</label>
                            <select class="form-select w-50 ms-3 py-2 pe-4" id="routeDetailsChangeStatusFormSemitrailer2" name="semitrailer2_id"></select>
                        </li>
    
                        <li class="list-group-item d-flex align-items-center justify-content-between">
                            <input translate_string="accept_route" class="form-control btn btn-success py-3 me-1 mtr__translateValue" id="acceptRouteButton" onclick="sendJobDecision(${routeDetails.id}, this.value)" name="jobDecision" value="${lang.accept_route}">
                        </li>
                    </form>
                `);

            var drivers = getUserDrivers();
            drivers.forEach(function (driver, index) {
                $(`
                    <option value="${driver.id}" ${(routeDetails.driver != null && routeDetails.driver.id == driver.id) ? "selected" : ''}>
                        ${driver.name}
                    </option> 
                `).appendTo("#routeDetailsChangeStatusFormDriver");
            });

            var trucks = getUserTrucks();
            if (trucks.length > 0) {
                trucks.forEach(function (truck, index) {
                    $(`
                        <option value="${truck.id}">${truck.name}</option> 
                        `).appendTo("#routeDetailsChangeStatusFormTruck");
                });
            } else {
                $(`
                        <option value="" class="mtr__translateText" translate_string="no_trucks" selected>${lang.no_trucks}</option> 
                        `).appendTo("#routeDetailsChangeStatusFormTruck");
                $("#routeDetailsChangeStatusFormTruck").attr('disabled', 'disabled');
                $("#acceptRouteButton").attr('disabled', 'disabled');
            }

            var semitrailers = getUserSemitrailers();
            if (semitrailers.length > 0) {
                semitrailers.forEach(function (semitrailer, index) {
                    $(`
                        <option value="${semitrailer.id}">${semitrailer.name} </option> 
                        `).appendTo("#routeDetailsChangeStatusFormSemitrailer1");

                    $(`
                        <option value="${semitrailer.id}">${semitrailer.name} </option> 
                        `).appendTo("#routeDetailsChangeStatusFormSemitrailer2");
                });
            } else {
                $(`
                        <option value="" class="mtr__translateText" translate_string="no_semitrailers" selected>${lang.no_semitrailers}</option> 
                        `).appendTo("#routeDetailsChangeStatusFormSemitrailer1");
                $("#routeDetailsChangeStatusFormSemitrailer1").attr('disabled', 'disabled');

                $(`
                        <option value="" class="mtr__translateText" translate_string="no_semitrailers" selected>${lang.no_semitrailers}</option> 
                        `).appendTo("#routeDetailsChangeStatusFormSemitrailer2");
                $("#routeDetailsChangeStatusFormSemitrailer2").attr('disabled', 'disabled');
            }
        } else {
            $("#routeConfirmation").hide();
        }

        $("#loadsDetails .list-group").html('');

        routeDetails.loads.forEach(function (load, index) {
            $(`
                <li class="list-group-item p-0">
                    <div class="card-header collapsed d-flex align-items-center justify-content-between" data-bs-toggle="collapse" data-bs-target="#loadDetailsCollapse${index}"
                        aria-expanded="false" aria-controls="loadDetailsCollapse${index}">
                        <span><span class="mtr__translateText" translate_string="load"> ${lang.load} <span class="mtr__translateText" translate_string="number_of"> ${lang.number_of} </span>${(index + 1)}</span> (${lang.id}: ${load.id})</span>
                        <i class="fas fa-arrow-down"></i>
                        </div>
                    <ul id="loadDetailsCollapse${index}" class="list-group list-group-flush collapse">
                        <li class="list-group-item d-flex align-items-center justify-content-between">
                            <span class="fw-bold mtr__translateText" translate_string="status">${lang.status}</span>
                                ${(routeDetails.status == "available") ?
                    (load.load_status == 'available') ? `<span class="mtr__translateText" translate_string="load_available">` + lang.load_available + `</span>` :
                        (load.load_status == 'accepted') ? `<span class="mtr__translateText" translate_string="load_accepted">` + lang.load_accepted + `</span>` :
                            (load.load_status == 'notified') ? `<span class="mtr__translateText" translate_string="load_notified">` + lang.load_notified + `</span>` :
                                (load.load_status == 'charged') ? `<span class="mtr__translateText" translate_string="load_charged">` + lang.load_charged + `</span>` :
                                    (load.load_status == 'discharged') ? `<span class="mtr__translateText" translate_string="load_discharged">` + lang.load_discharged + `</span>` : '-'
                    :
                    `
                        <select class="form-select w-50 ms-3 py-2 pe-4" id="changeLoadStatusSelect" onchange="changeLoadStatus(${load.id})">
                            <option class="mtr__translateText" translate_string="load_available" value="available" ${(load.load_status == 'available') ? 'selected' : ''} >
                                ${lang.load_available}
                            </option>
                            <option class="mtr__translateText" translate_string="load_accepted" value="accepted" ${(load.load_status == 'accepted') ? 'selected' : ''}>
                                ${lang.load_accepted}
                            </option>
                            <option class="mtr__translateText" translate_string="load_notified" value="notified" ${(load.load_status == 'notified') ? 'selected' : ''}>
                                ${lang.load_notified}
                            </option>
                            <option class="mtr__translateText" translate_string="load_charged" value="charged" ${(load.load_status == 'charged') ? 'selected' : ''}>
                                ${lang.load_charged}
                            </option>
                            <option class="mtr__translateText" translate_string="load_discharged" value="discharged" ${(load.load_status == 'discharged') ? 'selected' : ''}>
                                ${lang.load_discharged}
                            </option>
                        </select>
                    `
                }
                        </li>
                        <li class="list-group-item d-flex align-items-center justify-content-between">
                            <span class="mtr__translateText" translate_string="info">${lang.info}</span>
                            <span>${(load.info) ? load.info : '-'}</span>
                        </li>
                        <li class="list-group-item d-flex align-items-center justify-content-between">
                            <span class="mtr__translateText" translate_string="charge_date">${lang.charge_date}</span>
                            <span>${(load.load_date) ? load.load_date : '-'}</span>
                        </li>
                        <li class="list-group-item d-flex align-items-center justify-content-between">
                            <span class="mtr__translateText" translate_string="charge_address">${lang.charge_address}</span>
                            <span class="w-50 text-end">
                                ${(load.from_location) ? load.from_location.street + "<br>" + load.from_location.zipcode + " " + load.from_location.city + " (" + load.from_location.country + ")" : '-'}
                            </span>
                        </li>
                        <li class="list-group-item d-flex align-items-center justify-content-between">
                            <span class="mtr__translateText" translate_string="discharge_date">${lang.discharge_date}</span>
                            <span>${(load.unload_date) ? load.unload_date : '-'}</span>
                        </li>
                        <li class="list-group-item d-flex align-items-center justify-content-between">
                            <span class="mtr__translateText" translate_string="discharge_address">${lang.discharge_address}</span>
                            <span class="w-50 text-end">
                                ${(load.to_location) ? load.to_location.street + "<br>" + load.to_location.zipcode + " " + load.to_location.city + " (" + load.to_location.country + ")" : '-'}
                            </span>
                        </li>
                        <li class="list-group-item d-flex align-items-center justify-content-between">
                            <span class="mtr__translateText" translate_string="weight">${lang.weight} (t)</span>
                            <span>${((load.weight) ? (load.weight + "t") : '-')}</span>
                        </li>
                        <li class="list-group-item d-flex align-items-center justify-content-between">
                            <span class="mtr__translateText" translate_string="dimensions">${lang.dimensions} (m)</span>
                            <span class="w-50 text-end">
                                ${((load.width) ? load.width : '-')
                + " x "
                + ((load.length) ? load.length : '-')
                + "x "
                + ((load.height) ? load.height : '-')
                + `m<br>(${`<span class="mtr__translateText" translate_string="width_short">` + lang.width_short + `</span>`} x ${`<span class="mtr__translateText" translate_string="length_short">` + lang.length_short + `</span>`} x ${`<span class="mtr__translateText" translate_string="height_short">` + lang.height_short + `</span>`})`
                }
                            </span>
                        </li>
                        <li class="list-group-item d-flex align-items-center justify-content-between">
                            <span class="mtr__translateText" translate_string="side">${lang.side}</span>
                            <span class="mtr__translateText" translate_string="${(load.side == 'flank') ? 'flank_side' : (load.side == 'top') ? 'lang.top_side' : (load.side == 'back') ? 'back_side' : '-'}">
                                ${(load.side == 'flank') ? lang.flank_side : (load.side == 'top') ? lang.top_side : (load.side == 'back') ? lang.back_side : '-'}
                            </span>
                        </li>
                        <li class="list-group-item d-flex align-items-center justify-content-between">
                            <span>${`<span class="mtr__translateText" translate_string="palette">` + lang.palette + `</span>`} (${`<span class="mtr__translateText" translate_string="count">` + lang.count + `</span>`})</span>
                            <span>${(load.palette) ? load.palette : '-' + " (" + (load.pallets_number) ? load.pallets_number : '-' + ")"}</span>
                        </li>
                        <li class="list-group-item d-flex align-items-center justify-content-between">
                            <span class="mtr__translateText" translate_string="adr">${lang.adr}</span>
                            <span>${(load.adr) ? `<span class="mtr__translateText" translate_string="yes">` + lang.yes + `</span>` : `<span class="mtr__translateText" translate_string="no">` + lang.no + `</span>`}</span>
                        </li>
                        <li class="list-group-item d-flex align-items-center justify-content-between">
                            <span class="mtr__translateText" translate_string="status">${lang.delivery_notification}</span>
                            <span>${(load.delivery_notification) ? `<span class="mtr__translateText" translate_string="yes">` + lang.yes + `</span>` : `<span class="mtr__translateText" translate_string="no">` + lang.no + `</span>`}</span>
                        </li>
                    </ul>
                </li>
            `).appendTo("#loadsDetails .list-group");
        }, routeDetails);

        var toShow = (isUserLogged()) ? ['#content', '#userProfileWrapper', '#backToRoutesListButton', '#routeDetailsWrapper', '#logoutButton'] : ['#content', '#loginFormWrapper', '#informationsWrapper'];
    }
    else {
        var toShow = (isUserLogged()) ? ['#content', '#userProfileWrapper', '#backToHomeButton', '#routeListWrapper', '#logoutButton'] : ['#content', '#loginFormWrapper', '#informationsWrapper'];
    }

    if (show) {
        endLoading(toShow);
    }
}

function sendJobDecision(id, jobDecision) {
    if (!isUserLogged()) return null;

    var toShow = (isUserLogged()) ? ['#content', '#userProfileWrapper', '#backToRoutesListButton', '#routeDetailsWrapper', '#logoutButton'] : ['#content', '#loginFormWrapper', '#informationsWrapper'];

    startLoading(function () {
        $.ajax({
            type: 'POST',
            url: appURL + `api/route/${id}/changeStatus`,
            crossDomain: true,
            data: {
                "api_token": localStorage.getItem('api_token'),
                "locale": localStorage.getItem('locale'),
                "carrier_id": getUserCarrier().id,
                "driver_id": document.getElementById('routeDetailsChangeStatusFormDriver').value.toString(),
                "truck_id": document.getElementById('routeDetailsChangeStatusFormTruck').value.toString(),
                "semitrailer1_id": document.getElementById('routeDetailsChangeStatusFormSemitrailer1').value.toString(),
                "semitrailer2_id": document.getElementById('routeDetailsChangeStatusFormSemitrailer2').value.toString(),
                "jobDecision": jobDecision
            },
            dataType: 'json',
            success: function (responseData) {
                var responseData = responseData;

                if (responseData.status == "error") {
                    var responseMessage = "";
                    for (var message in responseData.message) {
                        if (responseData.message.hasOwnProperty(message)) {
                            responseMessage += responseData.message[message] + '<br>';
                        }
                    }
                    endLoading(toShow, addToast('Vision Cargo Mobile', responseMessage, 'danger'));
                } else {
                    getRoutes('accepted', false);
                    getRouteDetails(id, false);
                    setTimeout(function () { endLoading(toShow, addToast('Vision Cargo Mobile', responseData.message, 'success')); }, 3000);
                }
            },
            error: function (responseData) {
                var message = JSON.parse(responseData.responseText).message
                endLoading(toShow, addToast('Vision Cargo Mobile', message, 'danger'))
            }
        });
    });

    return true;
}

function changeLoadStatus(id) {
    if (!isUserLogged()) return null;

    var newStatus = document.getElementById('changeLoadStatusSelect').value;

    if (confirm(lang.change_load_status_confirm)) {
        $.ajax({
            type: 'POST',
            url: appURL + `api/load/${id}/changeStatus`,
            crossDomain: true,
            data: {
                "api_token": localStorage.getItem('api_token'),
                "load_status": newStatus,
                "locale": localStorage.getItem('locale')
            },
            dataType: 'json',
            success: function (responseData) {
                if (responseData.status == "error") {
                    var responseMessage = "";
                    for (var message in responseData.message) {
                        if (responseData.message.hasOwnProperty(message)) {
                            responseMessage += responseData.message[message] + '<br>';
                        }
                    }

                    addToast('Vision Cargo Mobile', responseMessage, 'danger');
                } else {
                    addToast('Vision Cargo Mobile', responseData.message, 'success');
                }
            },
            error: function (responseData) {
                var message = JSON.parse(responseData.responseText).message
                endLoading(toShow, addToast('Vision Cargo Mobile', message, 'danger'))
            }
        });
    } else {
        addToast('Vision Cargo Mobile', lang.change_load_status_canceled, 'danger');
    }

    return true;
}
